# Query-based Knowledge Transfer (QKT)


## Overview
QKT aims to facilitate tailored knowledge acquisition and integration to meet specific client needs without direct data exchange. This approach not only addresses the immediate adaptation to new concepts but also ensures that learning encompasses both new and existing relevant knowledge. QKT is designed to overcome the challenges posed by data heterogeneity and privacy constraints in decentralized collaborative learning environments.

## Installation

### Setting Up the Environment

To set up the project environment, execute the following command to create a Conda environment using the provided `conda-environment.yml` file:

```bash
conda env create -f conda-environment.yml
```


## Usage

### Activating the Environment
Before running any of the commands below, activate the Conda environment:

```bash
conda activate qkt_env
```

### Clients Local Training
To perform local training on clients with specific configurations:
```angular2html
python QKT/train_clients.py trainer.max_epochs=100 datamodule=cifar10 datamodule.fair_val=True model=resnet18 logger.group=train logger.tags=[train,fair_val,cifar10,QKT_pathological_var,10clients,3classes,var_size,variable_dataset_size] logger.project=qkt num_clients=10 split_function=pathological_split

```

### QKT Preliminary Experiments
To conduct QKT experiments, you first need the `"train_exp_id"` of the clients' local training experiment, which can be found in WandB.

#### Single-Class and Multi-Class Queries
For QKT experiments involving either a single-class or multi-class query, the parameter `num_classes_to_select` is used to specify the type of query:

- For a **single-class query**, set: `num_classes_to_select=1`
- For a **multi-class query**, set: `num_classes_to_select=-1`

#### Example: Running a QKT Experiment
To perform a QKT experiment, use the following command:

```bash
python QKT/transfer_knowledge_QKT_detailed.py teacher_client=[0,1,2,3,4,5,6,7,8,9] learner_client=[0,1,2,3,4,5,6,7,8,9] trainer.max_epochs=25 train_exp_id="the wandb id of the training exp" qkt_multi_teachers=True detailed_testing=True two_stage_qkt=True two_stage_starting_point=qkt num_classes_to_select=1 alpha_data_free=True goal_class_boost=1.5
```

- `teacher_client` and `learner_client`: Specify which clients are involved in the experiment.
- `num_classes_to_select`: Set to `1` for a single-class query or `-1` for a multi-class query.


